unit RRHint;

interface

Uses
  Windows, Controls, Forms, Graphics, Messages;

type
TRRHintWindow = class(THintWindow)
private
  procedure WMNCPaint(var Message: TMessage); message WM_NCPAINT;
protected
  procedure CreateParams(var Params : TCreateParams); override;
  procedure Paint; override;
end;

implementation

{ TRRHintWindow }


procedure TRRHintWindow.CreateParams(var Params: TCreateParams);
begin
  inherited;
  Brush.Style := bsClear;
end;

procedure TRRHintWindow.Paint;
var
  R : TRect;
begin
  with Canvas do begin
    R := ClientRect;
// seta a cor de fundo
    Brush.Color := Color;
// desenha em modo transparente
    SetBkMode(Handle,Transparent);
    with R do begin
// desenha o retngulo
      RoundRect(Left,Top,Right,Bottom,15,15);
// ajusta tamanho do retngulo para o texto
      R.Left := R.Left + 2;
      R.Top := R.Top + 2;
// desenha o texto
      DrawText(Handle,PChar(Caption),-1,R,DT_LEFT or DT_NOPREFIX or DT_WORDBREAK);
    end;
  end;
end;

procedure TRRHintWindow.WMNCPaint(var Message: TMessage);
begin
// nao faz nada, elimina o desenho da borda
end;

initialization
  Application.ShowHint := False;
  HintWindowClass := TRRHintWindow;
  Application.ShowHint := True;
end.
